require( "quest/m1_florida/convout.lua" );
combine_speech_tables();

function do_tutorial(dialog)
	scene.FLO:SetMode(MODE.CUTSCENE);
	sfx:PlaySFX("audio/sfx/tutorial_popup.ogg");
	game:Set("florida_tutorial", 1);
	scene:Spawn(tutorial_arrow_spec);
	coroutine.yield(RESUME.NOW);
	
	-- dump meshes for all things we can't click on.... tedious!
	local non_tut_actor = 
	{
		"BUTTERFLY_001",
		"BUTTERFLY_002",
		"BUTTERFLY_003",
		"BUTTERFLY_004",
		"BUTTERFLY_005",
		"BUTTERFLY_006",
		"BUTTERFLY_007",
		"BUTTERFLY_008",
		"BUTTERFLY_026",
		"BUTTERFLY_027",
		"BUTTERFLY_028",
		"FLO",
		"GREG",
		"HERB",
		"BAGS",
		"TO_PETSPA",
		"TO_DINER",
		--"DINER_DOOR",
		--"PETSPA_DOOR",
		"TO_INTERSECTION",
		"DIANE_WINDOW",
		"DIANE_DOOR",
		"DYE",
		"LAUNDRY_TRUCK",
	};
	
	for i,v in pairs(non_tut_actor) do
		scene[ v ]:DumpZone();
	end
	
	dialog:Say("florida_tutorial_welcome");
	coroutine.yield(RESUME.ON_CLICK);
	
	dialog:Say("florida_tutorial_butterfly");
	scene.BUTTERFLY_001:LoadZone("quest/butterflies/001");
	scene.TUTORIAL_ARROW:LoadImage("arrow_butterfly1");
	scene.FLO:SetMode(MODE.FOLLOWCLICKS);
	
	-- wait for butterfly to be clicked (script in butterflies.lua)
	while game:Get("florida_tutorial") == 1 do
		delay(1);
	end;
	
	scene.BUTTERFLY_001:DumpZone();
	
	dialog:Say("");
	dialog:SetAlpha(0);
	scene.TUTORIAL_ARROW:SetAlpha(0);
	
	-- wait for napkin to disappear
	while game:Get("florida_tutorial") == 2 do
		delay(1);
	end;
	
	dialog:Say("florida_tutorial_walk");
	dialog:SetAlpha(1);
	sfx:PlaySFX("audio/sfx/tutorial_popup.ogg");
	scene.TO_PETSPA:LoadZone("to_petspa");
	scene.TUTORIAL_ARROW:LoadImage("arrow_street");
	scene.TUTORIAL_ARROW:SetAlpha(1);
	
	-- wait for petspa to be clicked
	while game:Get("florida_tutorial") == 3 do
		delay(1);
	end;
	
	dialog:Say("");
	dialog:SetAlpha(0);
	scene.TUTORIAL_ARROW:SetAlpha(0);
	
	while game:Get("florida_tutorial") == 4 do
		delay(1);
	end;
	
	dialog:JumpToPoint { x = 1383, y = dialog:GetPosition().y };
	dialog:Say("florida_tutorial_pickup");
	dialog:SetAlpha(1);
	sfx:PlaySFX("audio/sfx/tutorial_popup.ogg");
	scene.BAGS:LoadZone("bags");
	scene.TUTORIAL_ARROW:LoadImage("arrow_bags");
	scene.TUTORIAL_ARROW:SetAlpha(1);
	
	-- wait for bags to be clicked
	while game:Get("florida_tutorial") == 5 do
		delay(1);
	end;
	
	dialog:Say("");
	dialog:SetAlpha(0);
	scene.TUTORIAL_ARROW:SetAlpha(0);
	
	-- wait for dialog to finish
	while game:Get("florida_tutorial") == 6 do
		delay(1);
	end;
	
	dialog:Say("florida_tutorial_pickup_butterfly_A");
	dialog:SetAlpha(1);
	sfx:PlaySFX("audio/sfx/tutorial_popup.ogg");
	--scene.BUTTERFLY_007:LoadZone("quest/butterflies/007");
	scene.TO_DINER:LoadZone("to_diner");
	scene.TUTORIAL_ARROW:LoadImage("arrow_back_street");
	scene.TUTORIAL_ARROW:SetAlpha(1);
	
	-- wait for Flo to click the arrow to go back down the street
	while game:Get("florida_tutorial") == 7 do
		delay(1);
	end;
	
	dialog:Say("");
	dialog:SetAlpha(0);
	scene.TUTORIAL_ARROW:SetAlpha(0);
	
	-- wait for Flo to walk back down the street
	while game:Get("florida_tutorial") == 8 do
		delay(1);
	end;
	
	dialog:JumpToPoint { x = 110, y = dialog:GetPosition().y };
	
	dialog:Say("florida_tutorial_pickup_butterfly_B");
	dialog:SetAlpha(1);
	sfx:PlaySFX("audio/sfx/tutorial_popup.ogg");
	scene.BUTTERFLY_001:LoadZone("quest/butterflies/001");
	scene.TUTORIAL_ARROW:LoadImage("arrow_butterfly1");
	scene.TUTORIAL_ARROW:SetAlpha(1);
	
	scene["BUTTERFLY_001"]:LoadZone("quest/butterflies/001");
	
	-- wait for buttefly to be clicked (script in butterflies.lua)
	while game:Get("florida_tutorial") == 9 do
		delay(1);
	end;
	
	scene.TUTORIAL_ARROW:SetAlpha(0);
	
	dialog:Say("florida_tutorial_pickup_butterfly_C");
	scene.FLO:SetMode(MODE.CUTSCENE);
	coroutine.yield(RESUME.ON_CLICK);
	
	dialog:LoadImage("quest/shared/tutorial_dialog_medium");
	dialog:JumpToPoint { x = 0, y = 0 };
	dialog:ModifySaySpec
	{
		y = 315,
		x = 480,
		w = 275,
		h = 300,
	};
	scene.TUTORIAL_ARROW:SetAlpha(1);
	scene.TUTORIAL_ARROW:LoadImage("arrow_checklist");
	dialog:Say("florida_tutorial_napkin")
	coroutine.yield(RESUME.ON_CLICK);
	
	scene.TUTORIAL_ARROW:LoadImage("arrow_map");
	dialog:Say("florida_tutorial_map");
	coroutine.yield(RESUME.ON_CLICK);
	
	-- hokay, lets put all these back
	scene["BUTTERFLY_002"]:LoadZone("quest/butterflies/002");
	scene["BUTTERFLY_003"]:LoadZone("quest/butterflies/003");
	scene["BUTTERFLY_004"]:LoadZone("quest/butterflies/004");
	scene["BUTTERFLY_005"]:LoadZone("quest/butterflies/005");
	scene["BUTTERFLY_006"]:LoadZone("quest/butterflies/006");
	scene["BUTTERFLY_007"]:LoadZone("quest/butterflies/007");
	scene["BUTTERFLY_008"]:LoadZone("quest/butterflies/008");
	scene["BUTTERFLY_026"]:LoadZone("quest/butterflies/026");
	scene["BUTTERFLY_027"]:LoadZone("quest/butterflies/027");
	scene["BUTTERFLY_028"]:LoadZone("quest/butterflies/028");
	scene["FLO"]:LoadZone("quest/objects/flo");
	scene["GREG"]:LoadZone("quest/objects/gregherb");
	scene["HERB"]:LoadZone("quest/objects/gregherb");
	scene["BAGS"]:LoadZone("bags");
	scene["TO_PETSPA"]:LoadZone("to_petspa");
	scene["TO_DINER"]:LoadZone("to_diner");
	--scene["DINER_DOOR"]:LoadZone("diner_door");
	--scene["PETSPA_DOOR"]:LoadZone("petspa_door");
	scene["TO_INTERSECTION"]:LoadZone("to_intersection");
	scene["DIANE_WINDOW"]:LoadZone("diane_window");
	scene["DIANE_DOOR"]:LoadZone("diane_door");
	scene["DYE"]:LoadZone("dye");
	scene["LAUNDRY_TRUCK"]:LoadZone("laundry_truck");
	
	spawn_nav_arrow(diner_door_spec);
	
	scene.FLO:SetMode(MODE.FOLLOWCLICKS);
	
	scene.TUTORIAL_ARROW:Expire();
	dialog:Expire();
end;

flo_anim_table =
{
	"anim/flo/idles",
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};

flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(flo_speed);
		
		delay(1); -- wait for door to spawn
		
		if game:GetLastScene() == "m1_intersection" then
			actor:JumpToNamedPoint("intersection");
			actor:FaceNow(DIR.W);
			actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
			scene:SetCameraFollowActor(actor);
			actor:WalkTo("from_intersection");
			wait_walkto();
			actor:Face(DIR.S);
			
			scene.CAMERA:JumpToNamedPoint("camera_petspa");
			scene:SetCameraFollowActor(scene.CAMERA);
			actor:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
			actor:SetMode(MODE.FOLLOWCLICKS);
			
			spawn_nav_arrow(petspa_door_spec);
			
			game:SetString("map_position", "m1_dress");
		elseif game:GetLastScene() == "m1_dress" then
			scene.DOOR3:PlayAnim("Opened");
			actor:JumpToNamedPoint("petspa");
			actor:Face(DIR.S);
			actor:WalkTo("petspa_walkto");
			delay(2);
			scene.DOOR3:PlayAnim("Close");
			wait_walkto();
			actor:Face(DIR.S);
			
			--if not quest_added("check_with_betty") then
			--	wait_fade();
			--	add_quest("check_with_betty");
			--	wait_subscene();
			--end
			
			if game:Get("just_completed_wedding_dress") == 1 then
				if quest_complete("find_snookums") then
					if flo_after_napkin_prompt(actor) == false then
						run_super_conversation(actor, "conv_goto_module2_B");
					end
				end
				game:Set("just_completed_wedding_dress", 2);
			end
			
			spawn_nav_arrow(petspa_door_spec);
			
			actor:SetMode(MODE.FOLLOWCLICKS);
			
			game:SetString("map_position", "m1_dress");
		else -- m1_diner	
			scene.DOOR1:PlayAnim("Opened");
			actor:JumpToNamedPoint("diner");
			actor:Face(DIR.S);
			actor:WalkTo("diner_walkto");
			delay(2);
			scene.DOOR1:PlayAnim("Close");
			wait_walkto();
			actor:Face(DIR.S);
			
			if game:Get("florida_tutorial") < 1 then
				scene:Spawn(tutorial_dialog_spec);
				coroutine.yield(RESUME.NOW);
				
				scene.TUTORIAL_DIALOG:StartProc(do_tutorial);
			else
				spawn_nav_arrow(diner_door_spec);
				
				actor:SetMode(MODE.FOLLOWCLICKS);
			end
			
			game:SetString("map_position", "m1_diner");
		end
	end;
	
	on_arrive = function(flo1, flo2)
		convproc("FLO", "quip_flo_general");
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

gregherb_anim_table =
{
	"anim/gregherb/stand",
	"anim/gregherb/talkw",
};

function talk_gregherb(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:WalkTo("bag_walkto");
	wait_walkto();
	flo:Face(DIR.E);
	scene.GREG:ModifySaySpec { bubble = BUBBLE.BUBBLE_SHOW + BUBBLE.BUBBLE_AUTOFLIP + BUBBLE.BUBBLE_AUTOVFLIP };
	scene.HERB:ModifySaySpec { bubble = BUBBLE.BUBBLE_SHOW + BUBBLE.BUBBLE_AUTOFLIP + BUBBLE.BUBBLE_AUTOVFLIP };
	if game:Get("talked_to_greg_herb") < 1 then
		run_super_conversation(flo, "conv_twinsA");
		game:Set("talked_to_greg_herb", 1);
	else
		run_super_conversation(flo, "conv_twinsB");
	end
	
	flo:WalkTo("petspa_walkto");
	wait_walkto();
	flo:Face(DIR.S);
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function gregherb_on_arrive(flo, gregherb)
	flo:FaceActor(gregherb);
	flo:StartProc(talk_gregherb);
end

greg_spec = 
{
	name = "GREG";
	halo = "quest/objects/gregherb";
	anim = gregherb_anim_table;
	
	command = function(actor)
		prepare_actor_text(actor, greg_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(greg_speed);
		actor:JumpToNamedPoint("greg");
		actor.on_arrive = gregherb_on_arrive;
		
		if game:Get("seen_bernie_with_suit") < 1 then
			actor:FaceNow(DIR.E);
		else
			actor:FaceNow(DIR.W);
		end
	end;
};

herb_spec = 
{
	name = "HERB";
	halo = "quest/objects/gregherb";
	anim = gregherb_anim_table;
	
	command = function(actor)
		prepare_actor_text(actor, herb_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(herb_speed);
		actor:JumpToNamedPoint("herb");
		actor.on_arrive = gregherb_on_arrive;
		
		if game:Get("seen_bernie_with_suit") < 1 then
			actor:FaceNow(DIR.E);
		else
			actor:FaceNow(DIR.W);
		end
	end;
	
};

bernie_spec = 
{
	name = "BERNIE";
	gfx = { anim = "anim/bernie/suit" };
	
	command = function(actor)
		prepare_actor_text(actor, bernie_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(bernie_speed);
		actor:JumpToNamedPoint("bernie");
		actor:FaceNow(DIR.W);
	end;
};

diane_spec = 
{
	name = "DIANE";
	gfx = { anim = "anim/diane/window" };
	
	command = function(actor)
		prepare_actor_text(actor, diane_text_spec);
		--actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(diane_speed);
		actor:JumpToNamedPoint("diane");
		actor:FaceNow(DIR.W);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	end;
};

function get_laundry_bag(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:WalkTo("bag_walkto");
	wait_walkto();
	flo:Face(DIR.E);
	
	-- flag to the tutorial that we've been clicked
	if game:Get("florida_tutorial") == 5 then
		game:Set("florida_tutorial", 6);
		scene.BAGS:DumpZone();
	end
	
	scene.GREG:ModifySaySpec { bubble = BUBBLE.BUBBLE_SHOW + BUBBLE.BUBBLE_AUTOFLIP + BUBBLE.BUBBLE_AUTOVFLIP };
	scene.HERB:ModifySaySpec { bubble = BUBBLE.BUBBLE_SHOW + BUBBLE.BUBBLE_AUTOFLIP + BUBBLE.BUBBLE_AUTOVFLIP };
	
	if game:Get("got_butterflybag") ~= 1 then
		run_super_conversation(flo, "conv_bag");
		
		addButterflyBag();
		
		complete_quest("butterfly_bag");
		wait_subscene();
	else
		run_super_conversation(flo, "conv_already_have_bag");
	end
	
	-- flag to the tutorial that we've finished
	if game:Get("florida_tutorial") == 6 then
		game:Set("florida_tutorial", 7);
	end
	
	flo:WalkTo("petspa_walkto");
	wait_walkto();
	flo:Face(DIR.S);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

bags_spec = 
{
	name = "BAGS";
	halo = "bags";
	
	command = function(actor)
		actor:SetDepthValue(470);
	end;
	
	on_arrive = function(flo, bags)
		flo:FaceActor(bags);
		flo:StartProc(get_laundry_bag);
	end;
};

function gotopetspa(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	-- flag the tutorial to continue
	if game:Get("florida_tutorial") == 3 then
		game:Set("florida_tutorial", 4);
	else
		scene.DINER_DOOR:Expire();
	end
	
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene:SetCameraFollowActor(scene.FLO);
	flo:WalkTo("from_diner");
	wait_walkto();
	flo:Face(DIR.S);
	
	scene.CAMERA:JumpToNamedPoint("camera_petspa");
	scene:SetCameraFollowActor(scene.CAMERA);
	flo:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	
	if game:Get("seen_bernie_with_suit") < 1 then
		run_super_conversation(flo, "conv_florida2_intro");
		scene.BERNIE:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		scene.BERNIE:PlayAnim("WalkOff");
		sfx:PlaySFX("audio/sfx/bernie_exit.ogg", true);
		wait_anim(scene.BERNIE);
		scene.BERNIE:Expire();
		delay(60);
		sfx:KillSFX();
		sfx:PlaySFX("audio/sfx/ambient_mod1.ogg", true);
		game:Set("seen_bernie_with_suit", 1);
		
		scene.GREG:Face(DIR.W);
		scene.HERB:Face(DIR.W);
	end
	
	-- flag tutorial we're ready to continue
	if game:Get("florida_tutorial") == 4 then
		game:Set("florida_tutorial", 5);
		scene.TO_PETSPA:DumpZone();
	else
		spawn_nav_arrow(petspa_door_spec);
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
	
	game:SetString("map_position", "m1_dress");
end

to_petspa_spec = 
{
	name = "TO_PETSPA";
	halo = "to_petspa";
	cursor = "cursor_arrow_e";
	goto_fn = gotopetspa
}

door1_spec =
{
	name = "DOOR1";
	gfx = {anim = "anim/m1_florida/door1"};
	
	command = function(actor)
		actor:PlayAnim("Closed");
		actor:SetDepthValue("1");
	end
}

function gotodiner(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	-- flag the tutorial to continue
	if game:Get("florida_tutorial") == 7 then
		game:Set("florida_tutorial", 8);
	else
		scene.PETSPA_DOOR:Expire();
	end
	
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene:SetCameraFollowActor(scene.FLO);
	flo:WalkTo("from_petspa");
	wait_walkto();
	flo:Face(DIR.S);
	
	flo:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene.CAMERA:JumpToNamedPoint("camera_diner");
	scene:SetCameraFollowActor(scene.CAMERA);
	
	-- flag tutorial we're ready to continue
	if game:Get("florida_tutorial") == 8 then
		game:Set("florida_tutorial", 9);
		scene.TO_DINER:DumpZone();
	else
		spawn_nav_arrow(diner_door_spec);
	end
	
	flo:SetMode(MODE.FOLLOWCLICKS);
	
	game:SetString("map_position", "m1_diner");
end

to_diner_spec = 
{
	name = "TO_DINER";
	halo = "to_diner";
	cursor = "cursor_arrow_w";
	goto_fn = gotodiner;
}

function enter_diner(flo)
	flo:SetMode(MODE.CUTSCENE);
	scene.DINER_DOOR:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	flo:WalkTo("diner");
	wait_walkto();
	
	goto_scene(flo, "m1_diner");
end

diner_door_spec = 
{
	name = "DINER_DOOR";
	halo = "diner_door";
	cursor = "cursor_arrow_n";
	goto_fn = enter_diner;
	point_at_fn = function(actor, enter)
		if actor:GetMode() ~= MODE.CUTSCENE then
			if enter then
				scene.DOOR1:PlayAnim("Open");
			else
				scene.DOOR1:PlayAnim("Close");
			end
		end
	end;
}

function enterpetspa(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("module_progress") < 3 then
		scene.PETSPA_DOOR:SetMode(MODE.CUTSCENE);
		flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		flo:WalkTo("petspa");
		wait_walkto();
		
		goto_scene(flo, "m1_dress");
	else
		run_super_conversation(flo, "quip_shop_closed");
		flo:SetMode(MODE.FOLLOWCLICKS);
	end
end

door3_spec =
{
	name = "DOOR3";
	gfx = {anim = "anim/m1_florida/door3"};
	
	command = function(actor)
		actor:PlayAnim("Closed");
		actor:SetDepthValue("1");
	end
}

petspa_door_spec = 
{
	name = "PETSPA_DOOR";
	halo = "petspa_door";
	cursor = "cursor_arrow_n";
	goto_fn = enterpetspa;
	point_at_fn = function(actor, enter)
		if actor:GetMode() ~= MODE.CUTSCENE and game:Get("module_progress") < 3 then
			if enter then
				scene.DOOR3:PlayAnim("Open");
			else
				scene.DOOR3:PlayAnim("Close");
			end
		end
	end;
}

function gotointersection(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene:SetCameraFollowActor(scene.FLO);
	flo:WalkTo("intersection_walkto");
	delay(150);
	goto_scene(flo, "m1_intersection", true);
end

to_intersection_spec = 
{
	name = "TO_INTERSECTION";
	halo = "to_intersection";
	cursor = "cursor_arrow_e";
	goto_fn = gotointersection;
}

function diane_window_conv(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("diane_window_conv") < 1 then
		run_super_conversation(flo, "quip_windowA");
		game:Set("diane_window_conv", 1);
	elseif game:Get("diane_window_conv") < 2 then
		run_super_conversation(flo, "quip_windowB");
		game:Set("diane_window_conv", 2);
	else -- < 3
		run_super_conversation(flo, "quip_windowC");
	end
	flo:WalkTo("diner_walkto");
	wait_walkto();
	flo:Face(DIR.S);
	flo:SetMode(MODE.FOLLOWCLICKS);
end;

diane_window_spec = 
{
	name = "DIANE_WINDOW";
	halo = "diane_window";
	gfx = { anim = "anim/m1_florida/diane_window" };
	
	command = function(actor)
		actor:SetDepthValue(200);
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		
		--if game:Get("got_red_dye") == 1 then
		--	actor:PlayAnim("Opened");
		--else
			actor:PlayAnim("Closed");
		--end
		actor:SetAlpha(0);
		
		if game:Get("module_progress") > 2 then
			actor:DumpZone();
		end
	end;
	
	on_arrive = function(flo, window)
		flo:FaceActor(window);
		flo:StartProc(diane_window_conv);
	end;
	
	on_use_inv = function(item, flo, diane_window)
		if item == "oil" then
			convproc("FLO", "quip_window_oil");
			return RESPONSE.INV_HANDLED;
		else
			return RESPONSE.INV_UNHANDLED;
		end
	end;
}

door2_spec =
{
	name = "DOOR2";
	gfx = {anim = "anim/m1_florida/door2"};
	
	command = function(actor)
		actor:PlayAnim("Closed");
		actor:SetDepthValue("1");
	end
}

function diane_to_door(no_knock)
	-- diane is coming down her stairs I guess
	if no_knock == nil or no_knock == false then
		sfx:PlaySFX("audio/sfx/door_knock.ogg");
		delay(30);
	end
	
	scene.DIANE:SetAlpha(0);
	scene.DIANE_WINDOW:SetAlpha(1);
	scene.DIANE_WINDOW:DumpZone();
	delay(30);
	
	scene.DOOR2:PlayAnim("Open");
	wait_anim(scene.DOOR2);
	--scene.DIANE_DOOR:LoadImage("diane_door_open");
	sfx:PlaySFX("audio/sfx/door_open.ogg");
	
	-- jump diane to the door, and set up her normal animations
	scene.DIANE:DumpAnimFile("anim/diane/window");
	scene.DIANE:LoadAnimFile("anim/diane/stand");
	scene.DIANE:LoadAnimFile("anim/diane/talkw");
	scene.DIANE:PlayAnim("DoStandW");
	scene.DIANE:SetAlpha(1);
	
	game:Set("diane_at_door", 1);
end

function diane_to_window()
	-- diane is going back to her window
	--scene.DIANE_DOOR:LoadImage("diane_door_closed");
	sfx:PlaySFX("audio/sfx/door_close.ogg");
	scene.DIANE:SetAlpha(0);
	scene.DOOR2:PlayAnim("Close");
	wait_anim(scene.DOOR2);
	delay(30);
	
	-- jump diane back to the window and set up her window animations
	scene.DIANE:DumpAnimFile("anim/diane/stand");
	scene.DIANE:DumpAnimFile("anim/diane/talkw");
	scene.DIANE:LoadAnimFile("anim/diane/window");
	scene.DIANE:SetAlpha(1);
	scene.DIANE_WINDOW:SetAlpha(0);
	scene.DIANE:PlayAnim("DoStandW");
	
	scene.DIANE_WINDOW:LoadZone("DIANE_WINDOW");
	
	game:Set("diane_at_door", 0);
end

function diane_conv(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	if game:Get("module_progress") < 3 then
		diane_to_door();
		
		if game:Get("first_time_talk_diane") < 1 then
			run_super_conversation(flo, "conv_diane_intro");
			game:Set("first_time_talk_diane", 1);
			diane_to_window();
			
			if not quest_added("red_bottle") and not quest_added("dianes_window") then
				add_quest("red_bottle", false);
				add_quest("dianes_window");
			elseif not quest_added("dianes_window") then
				add_quest("dianes_window");
			end
			
			flo:WalkTo("diner_walkto");
			wait_walkto();
			flo:Face(DIR.S);
		elseif not quest_complete("give_diane_oil") and BAG_INV:CheckInventory("oil") == false then
			run_super_conversation(flo, "conv_diane_need_oil");
			diane_to_window();
			flo:WalkTo("diner_walkto");
			wait_walkto();
			flo:Face(DIR.S);
		elseif game:Get("got_red_dye") < 1 then -- have oil in inventory
			run_super_conversation(flo, "conv_diane_have_oil");
		else
			run_super_conversation(flo, "conv_diane_got_dye");
			diane_to_window();
			flo:WalkTo("diner_walkto");
			wait_walkto();
			flo:Face(DIR.S);
		end
	else
		sfx:PlaySFX("audio/sfx/door_knock.ogg");
		delay(30);
		run_super_conversation(flo, "conv_diane_gone");
		flo:WalkTo("diner_walkto");
		wait_walkto();
		flo:Face(DIR.S);
	end
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function give_diane_oil(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_diane_give_oil");
	diane_to_window();
	
	complete_quest("give_diane_oil", false);
	complete_quest("red_bottle", false);
	complete_quest("dianes_window", false);
	add_quest("give_betty_dye");
	
	-- precautionary setting of variables
	game:Set("looked_at_red_dye", 1);
	game:Set("first_time_talk_diane", 1);
	
	flo:WalkTo("diner_walkto");
	wait_walkto();
	flo:Face(DIR.S);
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function give_door_oil(flo)
	flo:SetMode(MODE.CUTSCENE);
	game:Set("first_time_talk_diane", 1); -- set this just in case player hasn't talked to diane yet
	diane_to_door();
	run_super_conversation(flo, "conv_diane_have_oil");
	give_diane_oil(flo);
end

-- called from strings_m1_florida.xml
function diane_get_dye(diane)
	diane_to_window();
	delay(30);
	
	diane:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	diane:PlayAnim("GrabDye_begin");
	wait_anim();
	
	scene.DYE:Expire();
	diane:PlayAnim("GrabDye_end");
	wait_anim();
	
	diane:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	
	diane_to_door(true);
	scene.FLO:Signal();
end

diane_door_spec = 
{
	name = "DIANE_DOOR";
	halo = "diane_door";
	--gfx = { image = "diane_door_closed" };
	
	command = function(actor)
		actor:SetDepthValue(320);
	end;
	
	on_arrive = function(flo, door)
		flo:FaceActor(door);
		flo:StartProc(diane_conv);
	end;
	
	on_use_inv = function(item, flo, door)
		if item == "oil" then
			if game:Get("diane_at_door") == 1 then
				flo:StartProc(give_diane_oil);
			else
				flo:StartProc(give_door_oil);
			end
			
			return RESPONSE.INV_HANDLED;
		else
			return RESPONSE.INV_UNHANDLED;
		end
	end;
}

function look_at_dye(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("looked_at_red_dye") < 1 then
		run_super_conversation(flo, "quip_dye_A");
		game:Set("looked_at_red_dye", 1);
		
		if not quest_added("red_bottle") then
			add_quest("red_bottle");
		end;
	else -- looked_at_red_dye == 1
		run_super_conversation(flo, "quip_dye_B");
	end
	
	flo:WalkTo("diner_walkto");
	wait_walkto();
	flo:Face(DIR.S);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function use_pole_on_dye(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:Face(DIR.E);
	run_super_conversation(flo, "quip_pole_dye");
	flo:Face(DIR.S);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

dye_spec = 
{
	name = "DYE";
	halo = "dye";
	gfx = { image = "dye" };
	
	command = function(actor)
	end;
	
	on_arrive = function(flo, dye)
		flo:FaceActor(dye);
		flo:StartProc(look_at_dye);
	end;
	
	on_use_inv = function(item, flo, dye)
		if item == "garmentpole" then
			flo:StartProc(use_pole_on_dye);
			return RESPONSE.INV_HANDLED;
		else
			return RESPONSE.INV_UNHANDLED;
		end
	end;
};

tutorial_dialog_spec = 
{
	name = "TUTORIAL_DIALOG";
	gfx = { image = "quest/shared/tutorial_dialog" };
	
	command = function(actor)
		actor:JumpToPoint { x = 110, y = 0 };
		actor:SetDepthValue(600);
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 };
			y = 30,
			x = 35,
			w = 370,
			h = 300,
			bubble = false,
			outline_size = 0,
			anchor = ANCHOR.TOP,
			halign = HALIGN.LEFT,
		};
	end;
}

tutorial_arrow_spec = 
{
	name = "TUTORIAL_ARROW";
	
	command = function(actor)
		actor:SetDepthValue(600);
	end;
}

flos_sign_spec = 
{
	name = "FLOS_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/bradley_hand_itc.mvec",
			color = { a = 1, r = 0.6, g = 0.18, b = 0.66 },
			outline_color = { a = 1, r = 0.6, g = 0.18, b = 0.66 },
			outline_size = 1,
			lineheight = 40,
		}
		
		actor:SetAlpha(0.7);
		
		actor:Say("text_flos_sign");
		actor:StopWalking();
		actor:SetPolygon({x=392,y=9}, {x=444,y=1}, {x=392,y=44}, {x=442,y=43});
		actor:TextToImage(5, 0);
	end;
}

diner_sign_spec = 
{
	name = "DINER_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/chaparel_pro.mvec",
			color = { a = 1, r = 0.6, g = 0.18, b = 0.66 },
			--outline_size = 1,
			lineheight = 30;
		}
		
		--actor:SetAlpha(0.7);
		
		actor:Say("text_diner_sign");
		actor:StopWalking();
		actor:SetPolygon({x=393,y=70}, {x=444,y=67}, {x=398,y=105}, {x=445,y=102});
		actor:TextToImage(0, 0);
	end;
}

eats_sign_spec = 
{
	name = "EATS_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			--font = "fonts/wiesbadenswing.mvec",
			color = { a = 1, r = 1, g = 1, b = 1.0 },
			outline_size = 0,
		}
		
		actor:SetAlpha(0.9);
		
		actor:Say("text_eats_sign");
		actor:StopWalking();
		actor:SetPolygon({x=406,y=151}, {x=425,y=126}, {x=413,y=154}, {x=430,y=130});
		actor:TextToImage(0, 0);
	end;
}

laundry_valet_sign_spec = 
{
	name = "LAUNDRY_VALET_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/kabel_lt_std_blk.mvec",
			color = { a = 1, r = 0.97, g = 0.85, b = 0.56 },
			--outline_size = 1,
			--outline_color = { a = 1, r = 0.5, g = 0.25, b = 0 },
			lineheight = 50,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_laundry_valet_sign");
		actor:StopWalking();
		actor:SetPolygon({x=1780,y=392}, {x=1982,y=392}, {x=1780,y=416}, {x=1982,y=416});
		actor:TextToImage(0, 0);
	end;
}

greg_herb_sign_spec = 
{
	name = "GREG_HERB_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/kabel_lt_std_blk.mvec",
			color = { a = 1, r = 0.97, g = 0.85, b = 0.56 },
			--outline_size = 1,
			--outline_color = { a = 1, r = 0.97, g = 0.85, b = 0.56 },
			lineheight = 50,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_greg_herb_sign");
		actor:StopWalking();
		actor:SetPolygon({x=1754,y=311}, {x=2018,y=310}, {x=1754,y=335}, {x=2018,y=335});
		actor:TextToImage(60, 0);
	end;
}

dress_shop_sign_spec = 
{
	name = "DRESS_SHOP_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(90);
		actor:ModifySaySpec
		{
			font = "fonts/hobo_std.mvec",
			color = { a = 1, r = 0.57, g = 0.07, b = 0.1 },
			outline_size = 0,
			lineheight = 30,
		}
		
		actor:SetAlpha(0.7);
		
		actor:Say("text_dress_shop_sign");
		actor:StopWalking();
		actor:SetPolygon({x=1435,y=160}, {x=1700,y=160}, {x=1435,y=195}, {x=1700,y=195});
		actor:TextToImage(10, 0);
		
	end;
}

florida_ave_sign_spec = 
{
	name = "FLORIDA_AVE_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/helvetica_rounded_lt_std_blk.mvec",
			color = { a = 1, r = 1, g = 1, b = 1 },
			outline_size = 0,
			lineheight = 35,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_florida_ave_sign");
		actor:StopWalking();
		actor:SetPolygon({x=88,y=165}, {x=218,y=165}, {x=88,y=186}, {x=218,y=186});
		actor:TextToImage(16, 6);
	end;
}

other_street_sign_spec = 
{
	name = "OTHER_STREET_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/helvetica_rounded_lt_std_blk.mvec",
			color = { a = 1, r = 1, g = 1, b = 1 },
			outline_size = 0,
			lineheight = 30,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_other_street_sign");
		actor:StopWalking();
		actor:SetPolygon({x=15,y=197}, {x=70,y=167}, {x=15,y=223}, {x=67,y=191});
		actor:TextToImage(6, 6);
	end;
}

camera_spec = 
{
	name = "CAMERA";
	command = function(actor)

		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:SetWalkSpeed(6);
		
		if game:GetLastScene() == "m1_intersection" then
			actor:JumpToNamedPoint("camera_intersection");
		elseif game:GetLastScene() == "m1_dress" then
			actor:JumpToNamedPoint("camera_petspa");
		else -- diner
			actor:JumpToNamedPoint("camera_diner");
		end
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		if IsCheatMode() then
			-- testing data
			--game:Set("got_butterflybag", 1);
			game:Set("got_napkin", 1);
			game:Set("found_phone", 1);
			game:Set("first_time_diner", 1);
			game:Set("cleaned_coffee_spill", 1);
			game:Set("diner_phone_ringing" , 1);
			
			--BAG_INV:AddInventory(inv_desc_oil);
			--BAG_INV:AddInventory(inv_desc_screwdriver);
			--BAG_INV:AddInventory(inv_desc_wirecutters);
			--BAG_INV:AddInventory(inv_desc_dye);
			--BAG_INV:AddInventory(inv_desc_mop);
			--BAG_INV:AddInventory(inv_desc_coffeecup);
			--BAG_INV:AddInventory(inv_desc_garmentpole);
		end
		
		spawn_nav_arrow(to_petspa_spec);
		spawn_nav_arrow(to_diner_spec);
		spawn_nav_arrow(to_intersection_spec);
		
		sfx:SetMusic("audio/music/walkingmusic.ogg", true);
		sfx:PlaySFX("audio/sfx/ambient_mod1.ogg", true);
		scene:SetRoomScale(300, 550, 0.6, 0.8);	--topline, bottomline, topscale, bottomscale
		
		game:Set("got_map", 1); -- we get the map first in Florida st
		local no_fade = game:GetLastScene() == "m1_intersection";
		fade_scene_up(false, no_fade);
		
		scene:SetCameraFollowActor(scene.CAMERA);		-- Attach the camera to follow "CAMERA" actor
		scene:SetCameraMargin { x = 400, y = 300 };
		
		if game:Get("got_red_dye") < 1 then
			scene:Spawn(dye_spec);
		end
		
		if game:Get("seen_bernie_with_suit") < 1 then
			scene:Spawn(bernie_spec);
		end
		
		if game:Get("module_progress") < 3 then
			scene:Spawn(greg_spec);
			scene:Spawn(herb_spec);
			scene:Spawn(diane_spec);
			scene:Spawn(bags_spec);
			scene:Spawn(diane_door_spec);
		end
		
		spawn_simple_hotspot("laundry_truck");
		spawn_simple_hotspot("end_of_street", 5);
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces", -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		{ "tree1", 100 },
		{ "car1", 430 },
		{ "car2", 430 },
		{ "hydrant1", 400 },
		{ "hydrant2", 400 },
		{ "lamp1", 400 },
		{ "lamp2", 400 },
		{ "lamp3", 400 },
		{ "van", 430 },
		{ "bags", 485 },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		camera_spec,
		scene_setup,
		
		flo_spec, -- the main actor
		diane_window_spec,
		flos_sign_spec,
		diner_sign_spec,
		--eats_sign_spec,
		dress_shop_sign_spec,
		florida_ave_sign_spec,
		other_street_sign_spec,
		greg_herb_sign_spec,
		laundry_valet_sign_spec,
		
		door1_spec,
		door2_spec,
		door3_spec,
	};
};
